package cn.com.duiba.sign.center.api.params;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import javax.print.DocFlavor;
import java.io.Serializable;
import java.util.List;

/**
 * Created by 歪大哥😁 on 2019-08-22.
 */
public class SignComponentActivityExtraParam implements Serializable {

    private static final long serialVersionUID = -2762116593331220153L;

    public static final String CYCLE_CONFIG = "cc";
    public static final String SUPPLEMENT_CONFIG = "sc";
    public static final String AD_POSITION_CONFIG = "apc";
    public static final String REWARD_CONFIG = "rc";
    public static final String TOOLS_CONFIG = "tc";
    public static final String DATA_JSON = "dj";
    public static final String PUBLISH = "pub";
    public static final String TITLE = "tt";
    public static final String RULE = "rl";
    public static final String VERSION = "version";
    public static final String ACT_START_TIME = "actStartTime";
    public static final String ACT_END_TIME = "actEndTime";
    public static final String MULTI_REWARD_CONFIG = "mrc";
    public static final String MULTI_TOOLS_CONFIG = "mtc";
    private static final String AUTO_SIGN = "as";
    public static final String USE_REMIND = "ur";
    public static final String BEST_PAY = "bestPay";
    public static final String CREDITS_URL = "creditsUrl";
    public static final String BUOY_CONFIG = "buoyConfig";

    // 标题
    private String title;
    // 规则
    private String rule;
    /**
     * 30天签到日历版本，1：1.0版本；2：2.0版本
     */
    private Integer version;
    /**
     * 签到开始时间
     */
    private Long actStartTime;
    /**
     * 签到结束时间
     */
    private Long actEndTime;
    // 签到周期配置
    private SignComponentCycleConfigParam cycleConfig;
    // 补签配置
    private SignComponentSupplementaryConfigParam supplementConfig;
    // 运营位配置
    private List<SignComponentAdPositionConfigParam> adPositionConfig;
    /**
     * 积分跳转链接
     */
    private String creditsWebUrl;

    /**
     * 浮标配置
     */
    private String buoyConfig;

    // -----------------签到配置---------------------------
    // 签到奖励配置
    private SignComponentRewardConfigParam rewardConfig;
    // 抽奖工具配置
    private SignComponentToolsConfigParam toolsConfig;

    // 多类型签到奖励配置
    private List<SignComponentRewardConfigParam> multiRewardConfig;
    // 多类型抽奖工具配置
    private List<SignComponentToolsConfigParam> multiToolsConfig;

    // 是否自动签到
    private boolean autoSign;

    /**
     * 开启提醒我按钮
     */
    private boolean useRemind;
    // -----------------界面配置---------------------------
    // 界面配置
    private String dataJson;
    // 活动是否发布 只要活动曾经发布过 此字段就是true
    private boolean publish;

    /**
     * 翼支付定制字段，JSON字符串
     */
    private String bestPay;

    public String getBestPay() {
        return bestPay;
    }

    public void setBestPay(String bestPay) {
        this.bestPay = bestPay;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Long getActStartTime() {
        return actStartTime;
    }

    public void setActStartTime(Long actStartTime) {
        this.actStartTime = actStartTime;
    }

    public Long getActEndTime() {
        return actEndTime;
    }

    public void setActEndTime(Long actEndTime) {
        this.actEndTime = actEndTime;
    }

    public boolean isPublish() {
        return publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public SignComponentCycleConfigParam getCycleConfig() {
        return cycleConfig;
    }

    public void setCycleConfig(SignComponentCycleConfigParam cycleConfig) {
        this.cycleConfig = cycleConfig;
    }

    public SignComponentSupplementaryConfigParam getSupplementConfig() {
        return supplementConfig;
    }

    public void setSupplementConfig(SignComponentSupplementaryConfigParam supplementConfig) {
        this.supplementConfig = supplementConfig;
    }

    public List<SignComponentAdPositionConfigParam> getAdPositionConfig() {
        return adPositionConfig;
    }

    public void setAdPositionConfig(List<SignComponentAdPositionConfigParam> adPositionConfig) {
        this.adPositionConfig = adPositionConfig;
    }

    public String getCreditsWebUrl() {
        return creditsWebUrl;
    }

    public void setCreditsWebUrl(String creditsWebUrl) {
        this.creditsWebUrl = creditsWebUrl;
    }

    public String getBuoyConfig() {
        return buoyConfig;
    }

    public void setBuoyConfig(String buoyConfig) {
        this.buoyConfig = buoyConfig;
    }

    public SignComponentRewardConfigParam getRewardConfig() {
        return rewardConfig;
    }

    public void setRewardConfig(SignComponentRewardConfigParam rewardConfig) {
        this.rewardConfig = rewardConfig;
    }

    public SignComponentToolsConfigParam getToolsConfig() {
        return toolsConfig;
    }

    public void setToolsConfig(SignComponentToolsConfigParam toolsConfig) {
        this.toolsConfig = toolsConfig;
    }

    public List<SignComponentRewardConfigParam> getMultiRewardConfig() {
        return multiRewardConfig;
    }

    public void setMultiRewardConfig(List<SignComponentRewardConfigParam> multiRewardConfig) {
        this.multiRewardConfig = multiRewardConfig;
    }

    public List<SignComponentToolsConfigParam> getMultiToolsConfig() {
        return multiToolsConfig;
    }

    public void setMultiToolsConfig(List<SignComponentToolsConfigParam> multiToolsConfig) {
        this.multiToolsConfig = multiToolsConfig;
    }

    public boolean isAutoSign() {
        return autoSign;
    }

    public void setAutoSign(boolean autoSign) {
        this.autoSign = autoSign;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public boolean isUseRemind() {
        return useRemind;
    }

    public void setUseRemind(boolean useRemind) {
        this.useRemind = useRemind;
    }

    public JSONObject serialize2Json() {
        JSONObject extra = new JSONObject();
        extra.put(TITLE, this.title);
        extra.put(RULE, this.rule);
        extra.put(VERSION, this.version);
        extra.put(ACT_START_TIME, this.actStartTime);
        extra.put(ACT_END_TIME, this.actEndTime);
        extra.put(CYCLE_CONFIG, this.cycleConfig);
        extra.put(SUPPLEMENT_CONFIG, this.supplementConfig);
        extra.put(AD_POSITION_CONFIG, this.adPositionConfig);
        extra.put(REWARD_CONFIG, this.rewardConfig);
        extra.put(TOOLS_CONFIG, this.toolsConfig);
        extra.put(MULTI_REWARD_CONFIG, this.multiRewardConfig);
        extra.put(MULTI_TOOLS_CONFIG, this.multiToolsConfig);
        extra.put(AUTO_SIGN, this.autoSign);
        extra.put(DATA_JSON, this.dataJson);
        extra.put(PUBLISH, this.publish);
        if (StringUtils.isNotBlank(bestPay)) {
            extra.put(BEST_PAY, this.bestPay);
        }
        extra.put(USE_REMIND, this.useRemind);
        if (StringUtils.isNotBlank(creditsWebUrl)) {
            extra.put(CREDITS_URL, this.creditsWebUrl);
        }
        if (StringUtils.isNotBlank(buoyConfig)) {
            extra.put(BUOY_CONFIG, this.buoyConfig);
        }
        return extra;
    }

    public SignComponentActivityExtraParam(JSONObject extra) {
        this.title = extra.getString(TITLE);
        this.rule = extra.getString(RULE);
        this.version = extra.getInteger(VERSION);
        this.actStartTime = extra.getLong(ACT_START_TIME);
        this.actEndTime = extra.getLong(ACT_END_TIME);
        this.cycleConfig = extra.getObject(CYCLE_CONFIG, SignComponentCycleConfigParam.class);
        this.supplementConfig = extra.getObject(SUPPLEMENT_CONFIG, SignComponentSupplementaryConfigParam.class);
        JSONArray apc = extra.getJSONArray(AD_POSITION_CONFIG);
        if (apc != null) {
            this.adPositionConfig = apc.toJavaList(SignComponentAdPositionConfigParam.class);
        }
        this.rewardConfig = extra.getObject(REWARD_CONFIG, SignComponentRewardConfigParam.class);
        this.toolsConfig = extra.getObject(TOOLS_CONFIG, SignComponentToolsConfigParam.class);
        JSONArray mrc = extra.getJSONArray(MULTI_REWARD_CONFIG);
        if (mrc != null) {
            this.multiRewardConfig = mrc.toJavaList(SignComponentRewardConfigParam.class);
        }
        JSONArray mtc = extra.getJSONArray(MULTI_TOOLS_CONFIG);
        if (mtc != null) {
            this.multiToolsConfig = mtc.toJavaList(SignComponentToolsConfigParam.class);
        }
        this.autoSign = extra.getBooleanValue(AUTO_SIGN);
        this.useRemind = extra.getBooleanValue(USE_REMIND);
        this.dataJson = extra.getString(DATA_JSON);
        this.publish = extra.getBooleanValue(PUBLISH);
        this.bestPay = extra.getString(BEST_PAY);
        this.creditsWebUrl = extra.getString(CREDITS_URL);
        this.buoyConfig = extra.getString(BUOY_CONFIG);
    }

    public SignComponentActivityExtraParam() {
    }

}
