package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignOperatingDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/21.
 */
@AdvancedFeignClient
public interface RemoteSignOperatingService {
    /**
     * 签到活动入库
     *
     * @param dto
     * @return
     */
    Long insert(SignOperatingDto dto);

    /**
     * 删除入库信息
     *
     * @param id
     * @return
     */
    Boolean deleteById(long id);

    /**
     * 更新入库信息
     *
     * @param dto
     * @return
     */
    Integer updateByIdUnNULL(SignOperatingDto dto);

    /**
     * 根据Id查询
     * @param id
     * @return
     */
    SignOperatingDto find(Long id);

    /**
     * 根据tb_sign_operating唯一索引反查入库信息
     * @param appId
     * @param signActivityId
     * @return
     */
    SignOperatingDto findByUniquenessKey(SignActivityTypeEnum signType, long appId, long signActivityId);

    /**
     * 统计参与活动的数量
     */
    Integer countAppByTypeAndActId(SignActivityTypeEnum signType, long signActivityId);

    /**
     * 查询appId对应的入库活动
     *
     * @param appId
     * @return
     */
    List<SignOperatingDto> findByTypeAndAppId(SignActivityTypeEnum signType, long appId);

    /**
     * 查询活动入库信息
     */
    List<SignOperatingDto> findByTypeAndActId(SignActivityTypeEnum signType, long actId);


    /**
     * 查询活动入库信息
     */
    List<SignOperatingDto> findByTypeAndActIds(SignActivityTypeEnum signType, List<Long> ids);

    /**
     * 批量保存
     * @param list
     * @return
     */
    Integer saveList(List<SignOperatingDto> list);

    /**
     * 根据活动id和活动类型删除
     * @param activityId
     * @param activityTypeEnum
     * @return
     */
    Integer deleteByActivityIdAndType(Long activityId, SignActivityTypeEnum activityTypeEnum);

    /**
     * 查询appId对应的入库活动（日历签到 + 契约签到）
     *
     * @param appId
     * @return
     */
    List<SignOperatingDto> findMultiTypeActByAppId(Long appId, Integer pageNo, Integer pageSize);

    /**
     * 查询appId对应的入库活动数量（日历签到 + 契约签到）
     *
     * @param appId
     * @return
     */
    Integer countMultiTypeActByAppId(Long appId);

    /**
     * 根据appId获取签到活动列表
     *
     * @param appId       appId
     * @param closeStatus 关闭状态-0发布1关闭
     * @param start 查询页（传null不分页）
     * @param limit 分页大小（传null不分页）
     * @return List<SignOperatingEntity>
     */
    List<SignOperatingDto> findActByAppId(Long appId, Integer closeStatus, Integer start, Integer limit);

    /**
     * 根据appId获取签到活动列表-计数
     *
     * @param appId       appId
     * @param closeStatus 关闭状态-0发布1关闭
     * @return Integer
     */
    Integer countActByAppId(Long appId, Integer closeStatus);
}
