package cn.com.duiba.sign.center.api.remoteservice.signtreasure;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signtreasure.SignTreasureActBackendDto;
import cn.com.duiba.sign.center.api.dto.signtreasure.SignTreasurePhaseDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteSignTreasureBackendService {
    /**
     * 保存活动并创建下一期
     * @param activity
     * @return
     * @throws BizException
     */
    Long saveSignTreasure(SignTreasureActBackendDto activity) throws BizException;

    /**
     * 根据活动id获取活动信息及当期或下期期次
     * @param actId
     * @return
     */
    SignTreasureActBackendDto findActWithPhase(Long actId);


    List<SignTreasurePhaseDto> findByActId(Long actId);
}
