/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class GenPokerUtil {
    private static final int SPADE = 1;
    private static final int CLUB = 2;
    private static final int HEART = 3;
    private static final int DIAMOND = 4;
    private static final ImmutableSet<Integer> POKER;

    private GenPokerUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Integer getRandomFromFull() {
        Random random = new Random();
        return (Integer)POKER.asList().get(random.nextInt(52));
    }

    public static Integer getRandomCardExpectInput(Integer card) {
        if (null == card) {
            return null;
        }
        Integer result = GenPokerUtil.getRandomFromFull();
        while (result.equals(card)) {
            result = GenPokerUtil.getRandomFromFull();
        }
        return result;
    }

    public static List<Integer> getRandomCards(int cardCount) {
        ArrayList<Integer> cards = new ArrayList<Integer>();
        if (cardCount <= 0) {
            return cards;
        }
        for (int i = 0; i < cardCount; ++i) {
            cards.add(GenPokerUtil.getRandomFromFull());
        }
        return cards;
    }

    public static String generateMatchCard(List<Integer> matchCards, int matchCardCount) {
        if (matchCardCount > matchCards.size()) {
            return null;
        }
        if (matchCardCount < 0 || CollectionUtils.isEmpty(matchCards)) {
            return null;
        }
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < matchCardCount; ++i) {
            prefix.append(matchCards.get(i)).append("_");
        }
        StringBuilder result = prefix;
        for (int i = matchCardCount; i < matchCards.size(); ++i) {
            result.append(GenPokerUtil.getRandomCardExpectInput(matchCards.get(i))).append("_");
        }
        String resultStr = result.toString();
        if (StringUtils.endsWith((String)resultStr, (String)"_")) {
            resultStr = result.toString().substring(0, resultStr.length() - 1);
        }
        return resultStr;
    }

    static {
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 14; ++i) {
            list.add(i * 10 + 1);
            list.add(i * 10 + 2);
            list.add(i * 10 + 3);
            list.add(i * 10 + 4);
        }
        POKER = ImmutableSet.copyOf((Collection)list);
    }
}

