package cn.com.duiba.cloud.single.sign.on.client.cache;

import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import java.util.List;

/**
 * @author xuanhongjian
 * 用户登录态缓存
 */
public interface LoginStateCache {

    /**
     * 失效本地登录态
     * @param keys ticket
     */
    void invalidateAll(List<String> keys);

    /**
     * 获取登录态
     * @param key ticket
     * @return 登录态
     */
    LoginStateDto get(String key);

    /**
     * 把登录态设置进缓存
     * @param key ticket
     * @param loginStateDto 登录态
     * @param expire 过期时间 5 单位秒
     */
    void set(String key,LoginStateDto loginStateDto,Long expire);

    /**
     * 失效过期的ticket
     * @param key ticket
     */
    void invalidate(String key);
}
