package cn.com.duiba.cloud.single.sign.on.client.tool;

import cn.com.duiba.cloud.single.sign.on.contract.tool.CookieUtil;
import cn.com.duiba.cloud.single.sign.on.contract.tool.RequestParams;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

/**
 * @author xuanhongjian
 */
public class SsoContext {

    public static String findTicket() {
        String ticketForUrl = SsoRequestTool.getRequestParamMap().get(CookieUtil.LOGIN_COOKIE_NAME);
        if (StringUtils.isNotBlank(ticketForUrl)) {
            return ticketForUrl;
        }
        return CookieUtil.getCookie(CookieUtil.LOGIN_COOKIE_NAME);
    }

    public static LoginStateDto getLoginState() {
        RequestParams requestParams = SsoRequestTool.getRequestParams();
        final JSONObject adminInfo = requestParams.getAdminInfo();
        return adminInfo.getObject("loginState", LoginStateDto.class);
    }

    public static void setLoginState(LoginStateDto loginState) {
        RequestParams requestParams = SsoRequestTool.getRequestParams();
        final JSONObject adminInfo = requestParams.getAdminInfo();
        adminInfo.put("loginState", loginState);
    }
}
