package cn.com.duiba.cloud.single.sign.on.client;

import cn.com.duiba.cloud.single.sign.on.client.cache.LoginStateCache;
import cn.com.duiba.cloud.single.sign.on.client.cache.impl.DefaultLoginStateCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author xuanhongjian
 */
@Configuration
@ComponentScan("cn.com.duiba.cloud.single.sign.on.client")
@Order(-1)
public class ClientAutoConfiguration implements WebMvcConfigurer {

    @Bean
    @ConditionalOnMissingBean(LoginStateCache.class)
    public LoginStateCache loginStateCache() {
        //每次授权10分钟，10分钟之后去sso重新获取登录态，并且刷新sso过期时间
        return new DefaultLoginStateCache();
    }
}
