/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.single.sign.on.client.cache.impl;

import cn.com.duiba.cloud.single.sign.on.client.cache.LoginStateCache;
import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class DefaultLoginStateCache
implements LoginStateCache {
    private final Cache<String, LoginStateDto> loginStateCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();

    @Override
    public void invalidateAll(List<String> keys) {
        Assert.notEmpty(keys, (String)"\u5931\u6548\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        this.loginStateCache.invalidateAll(keys);
    }

    @Override
    public LoginStateDto get(String key) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"ticket\u4e0d\u80fd\u4e3a\u7a7a");
        return (LoginStateDto)this.loginStateCache.getIfPresent((Object)key);
    }

    @Override
    public void set(String key, LoginStateDto loginStateDto, Long expire) {
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)key) && Objects.nonNull(loginStateDto) ? 1 : 0) != 0, (String)"ticket\u4e0d\u80fd\u4e3a\u7a7a");
        this.loginStateCache.put((Object)key, (Object)loginStateDto);
    }

    @Override
    public void invalidate(String key) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"ticket\u4e0d\u80fd\u4e3a\u7a7a");
        this.loginStateCache.invalidate((Object)key);
    }
}

