/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.single.sign.on.client.handler;

import cn.com.duiba.cloud.single.sign.on.client.cache.LoginStateCache;
import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import cn.com.duiba.cloud.single.sign.on.client.remoteservice.RemoteSsoService;
import cn.com.duiba.cloud.single.sign.on.client.tool.SsoContext;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.constants.SsoProperties;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.CookieUtil;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoginFilterHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginFilterHandler.class);
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private RemoteSsoService remoteSsoService;
    @Resource
    private LoginStateCache loginStateCache;

    public Boolean before(Object handler) {
        String ticket = SsoContext.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            this.returnNotLogin();
            return false;
        }
        LoginStateDto loginState = this.verifyTicket(ticket);
        if (loginState == null) {
            this.returnNotLogin();
            return false;
        }
        SsoContext.setLoginState(loginState);
        return true;
    }

    public int getOrder() {
        return 0;
    }

    protected void returnNotLogin() {
        try {
            if (SsoRequestTool.isAsynchronousRequests().booleanValue()) {
                SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code", (Object)"SSO:01001");
                model.put("success", (Object)false);
                model.put("notLogin", (Object)true);
                model.put("message", (Object)"\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
                SsoRequestTool.getResponse().getWriter().write(model.toJSONString());
            } else {
                SsoRequestTool.getResponse().sendRedirect(this.getLoginRedirectUrl());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u5740\u9519\u8bef", (Throwable)e);
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    private String getLoginRedirectUrl() {
        HashMap params = Maps.newHashMap();
        String redirect = this.getCurrentRedirect();
        params.put("redirect", redirect);
        String ssoHomeUrl = this.remoteSsoService.findSsoHomeUrl();
        String loginUrl = ssoHomeUrl + "/account/login";
        return UrlUtils2.appendParams((String)loginUrl, (Map)params);
    }

    protected String getCurrentRedirect() {
        String defaultUri = "/";
        HttpServletRequest request = SsoRequestTool.getRequest();
        String redirect = StringUtils.equals((CharSequence)defaultUri, (CharSequence)request.getRequestURI()) ? SsoRequestTool.getHomeUrl() + this.getDefaultRedirectUrl() : SsoRequestTool.getUrl();
        try {
            return URLEncoder.encode(redirect, "utf-8");
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    private String getDefaultRedirectUrl() {
        return this.ssoProperties.getDefaultRedirectUrl();
    }

    protected LoginStateDto verifyTicket(String ticket) {
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return null;
        }
        LoginStateDto loginState = this.loginStateCache.get(ticket);
        if (Objects.isNull(loginState)) {
            loginState = this.remoteSsoService.verifyTicket(ticket);
            if (loginState == null) {
                return null;
            }
            this.loginStateCache.set(ticket, loginState, 600L);
        }
        if (StringUtils.isBlank((CharSequence)SsoRequestTool.getCookie((String)"sso_ticket"))) {
            CookieUtil.setLoginCookie((String)ticket);
        }
        return loginState;
    }
}

