/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.exception.ErrorCode;
import cn.com.duiba.spider.util.maiquan.exception.MaiQuanSpiderException;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MeiPianSpider
extends AbstractSpider {
    public static final MeiPianSpider SPIDER = new MeiPianSpider();

    private MeiPianSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.MEIPIAN;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        Document document = this.doRequestDocument(param);
        Elements bodyDivs = document.body().select("div");
        Element articleMeta = bodyDivs.select(".article-meta").first();
        if (articleMeta == null) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u7f8e\u7bc7\u6587\u7ae0\u6807\u9898\u83b7\u53d6\u5931\u8d25");
        }
        Elements sections = bodyDivs.select(".content-container").select(".section");
        if (sections.size() <= 0) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u7f8e\u7bc7\u6587\u7ae0\u5185\u5bb9\u83b7\u53d6\u5931\u8d25");
        }
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), this.getContentSource().getCode());
        Element authorInfo = bodyDivs.select(".pc_right_bar").select(".authermessage").first();
        String style = authorInfo.select(".autherheader").first().attr("style");
        String s = StringUtils.splitByWholeSeparator((String)style, (String)"(")[1];
        String headImg = StringUtils.splitByWholeSeparator((String)s, (String)")")[0];
        String nickname = authorInfo.select(".authernickname").text();
        defaultDto.setAuthor(new DefaultDto.Author(nickname, headImg));
        ArrayList imgList = Lists.newArrayList();
        defaultDto.setImageList(imgList);
        String title = articleMeta.select("h1").select(".title").html();
        defaultDto.setPostTitle(title);
        String path = StringUtils.splitByWholeSeparator((String)param.getUrl(), (String)"//")[1];
        String[] strings = StringUtils.splitByWholeSeparator((String)path, (String)"/");
        defaultDto.setSourceId(strings[strings.length - 1]);
        defaultDto.setVideoUrl("");
        StringBuilder sb = new StringBuilder();
        sections.forEach(section -> {
            String text;
            Elements h3s;
            Elements texts;
            Elements imgs = section.select(".img-box").select("img");
            imgs.forEach(img -> imgList.add(img.attr("src")));
            if (sb.length() <= 100 && CollectionUtils.isNotEmpty((Collection)(texts = section.select(".text"))) && CollectionUtils.isNotEmpty((Collection)(h3s = texts.select("h3"))) && StringUtils.isNotBlank((String)(text = h3s.first().text()))) {
                sb.append(text).append("\r");
            }
        });
        defaultDto.setSourceAbstract(sb.toString());
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
    }
}

