/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.exception.ErrorCode;
import cn.com.duiba.spider.util.maiquan.exception.MaiQuanSpiderException;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PiPiXiaSpider
extends AbstractSpider {
    private static final String ITEM_DETAIL_URL = "https://h5.pipix.com/bds/webapi/item/detail/?item_id=%s";
    public static final PiPiXiaSpider SPIDER = new PiPiXiaSpider();

    private PiPiXiaSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.PIPIXIA;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        JSONObject note;
        String url = param.getUrl();
        String sourceUrl = param.getUrl();
        if (StringUtils.containsIgnoreCase((String)url, (String)"com/s/")) {
            url = this.doRequest(param).url().toString();
        }
        String itemId = StringUtils.splitByWholeSeparator((String)StringUtils.splitByWholeSeparator((String)url, (String)"?")[0], (String)"/item/")[1];
        param.setUrl(String.format(ITEM_DETAIL_URL, itemId));
        JSONObject json = this.doRequestJSON(param);
        if (json.getIntValue("status_code") != 0) {
            throw new MaiQuanSpiderException(ErrorCode.E005.getCode(), "\u76ae\u76ae\u867e\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25");
        }
        JSONObject item = json.getJSONObject("data").getJSONObject("item");
        if (item == null) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u76ae\u76ae\u867e\u5185\u5bb9\u83b7\u53d6\u5931\u8d25");
        }
        DefaultDto defaultDto = new DefaultDto(sourceUrl, this.getContentSource().getCode());
        defaultDto.setSourceId(itemId);
        JSONObject author = item.getJSONObject("author");
        String name = author.getString("name");
        String headImg = author.getJSONObject("avatar").getJSONArray("url_list").getJSONObject(0).getString("url");
        defaultDto.setAuthor(new DefaultDto.Author(name, headImg));
        JSONObject video = item.getJSONObject("video");
        if (video != null) {
            String videoUrl = video.getJSONObject("video_high").getJSONArray("url_list").getJSONObject(0).getString("url");
            defaultDto.setVideoUrl(videoUrl);
            defaultDto.setPostTitle(video.getString("text"));
            defaultDto.setSourceAbstract(video.getString("text"));
            JSONArray coverImags = video.getJSONObject("cover_image").getJSONArray("url_list");
            if (CollectionUtils.isNotEmpty((Collection)coverImags)) {
                String cover = coverImags.getJSONObject(0).getString("url");
                defaultDto.setImageList(Lists.newArrayList((Object[])new String[]{cover}));
            }
        }
        if ((note = item.getJSONObject("note")) != null) {
            defaultDto.setImageList(Lists.newArrayList());
            JSONArray imgs = note.getJSONArray("multi_image");
            String text = note.getString("text");
            if (CollectionUtils.isNotEmpty((Collection)imgs)) {
                imgs.forEach(img -> {
                    JSONObject imgJson = JSON.parseObject((String)img.toString());
                    String imgUrl = imgJson.getJSONArray("url_list").getJSONObject(0).getString("url");
                    defaultDto.getImageList().add(imgUrl);
                });
                defaultDto.setPostTitle(text);
                defaultDto.setSourceAbstract(text);
            } else {
                defaultDto.setPostTitle(StringUtils.substring((String)text, (int)0, (int)20));
                defaultDto.setSourceAbstract(StringUtils.substring((String)text, (int)0, (int)100));
            }
        }
        if (StringUtils.isBlank((String)defaultDto.getPostTitle())) {
            JSONObject share = item.getJSONObject("share");
            if (share != null) {
                defaultDto.setPostTitle(share.getString("title"));
            } else {
                defaultDto.setPostTitle(sourceUrl);
            }
        }
        return defaultDto;
    }

    public static void main(String[] args) {
        AbstractSpider.RequestParam param = new AbstractSpider.RequestParam("https://h5.pipix.com/s/Mbv8Fh/#");
        DefaultDto defaultDto = ContentSource.PIPIXIA.getSpider().smashOnErrorWithUnknown(param);
        System.err.println(JSON.toJSONString((Object)defaultDto));
        AbstractSpider.RequestParam param1 = new AbstractSpider.RequestParam("https://h5.pipix.com/s/MbxBE1/#");
        DefaultDto defaultDto1 = ContentSource.PIPIXIA.getSpider().smashOnErrorWithUnknown(param1);
        System.err.println(JSON.toJSONString((Object)defaultDto1));
        AbstractSpider.RequestParam param2 = new AbstractSpider.RequestParam("https://h5.pipix.com/item/6673335339047721219?app_id=1319&app=super&timestamp=1559715008&carrier_region=cn&region=cn&language=zh&utm_source=weixin");
        DefaultDto defaultDto2 = ContentSource.PIPIXIA.getSpider().smashOnErrorWithUnknown(param2);
        System.err.println(JSON.toJSONString((Object)defaultDto2));
    }

    @Override
    protected void checkHost(String url) {
    }
}

