/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;

public class MaiQuanSpiderUtil {
    private MaiQuanSpiderUtil() {
    }

    public static ContentSource resloveSourceByUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            String host = StringUtils.split((String)url, (String)"?")[0];
            if (StringUtils.indexOf((String)host, (String)"www.meipian") > -1) {
                return ContentSource.MEIPIAN;
            }
            if (StringUtils.indexOf((String)host, (String)"mp.weixin.qq.com") > -1) {
                return ContentSource.GONGZHONGHAO;
            }
            if (StringUtils.indexOf((String)host, (String)"pipix.com") > -1 || StringUtils.indexOf((String)host, (String)"ppx.ixigua.com") > -1) {
                return ContentSource.PIPIXIA;
            }
            if (StringUtils.indexOf((String)host, (String)"http://app.tiaoba360.com") > -1) {
                return ContentSource.TIAOBA;
            }
        }
        return ContentSource.UNKNOWN;
    }

    public static DefaultDto smash(AbstractSpider.RequestParam param) {
        return MaiQuanSpiderUtil.resloveSourceByUrl(param.getUrl()).getSpider().unitedStatesSmash(param);
    }

    public static DefaultDto smash(String url) {
        return MaiQuanSpiderUtil.smash(new AbstractSpider.RequestParam(url));
    }

    public static DefaultDto smashOnErrorWithUnknown(AbstractSpider.RequestParam param) {
        return MaiQuanSpiderUtil.resloveSourceByUrl(param.getUrl()).getSpider().smashOnErrorWithUnknown(param);
    }

    public static DefaultDto smashOnErrorWithUnknown(String url) {
        return MaiQuanSpiderUtil.smashOnErrorWithUnknown(new AbstractSpider.RequestParam(url));
    }

    public static void main(String[] args) {
        AbstractSpider.RequestParam param = new AbstractSpider.RequestParam("https://www.meipian9.cn/11q3y9n2?from=singlemessage&share_from=others&share_user_mpuuid=a50e6309ca97cba747cc8d44371fbf63&user_id=56720922&utm_medium=meipian_android&utm_source=singlemessage&uuid=8e102f928432853af43058d41fbfc5f4&v=4.12.0");
        DefaultDto smash = MaiQuanSpiderUtil.smash(param);
        System.err.println(JSON.toJSONString((Object)smash));
        AbstractSpider.RequestParam param1 = new AbstractSpider.RequestParam("http://m.baidu.com/s?word=%E7%99%BE%E5%BA%A6&from=1017188g&ua=bd_meizu*m9_chrome&tn=ntc");
        DefaultDto smash1 = MaiQuanSpiderUtil.smash(param1);
        System.err.println(JSON.toJSONString((Object)smash1));
        AbstractSpider.RequestParam param2 = new AbstractSpider.RequestParam("https://mp.weixin.qq.com/s?__biz=MzA5OTA0NDIyMQ==&mid=2653902389&idx=1&sn=e2065071c204a51188a7fa1369982ba6&chksm=8b53a827bc2421315c57d6acd26a353d2b378bf778db0277953d0a8fb667f13070d9b29179c7");
        DefaultDto smash2 = MaiQuanSpiderUtil.smash(param2);
        System.err.println(JSON.toJSONString((Object)smash2));
    }
}

