/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.exception.ErrorCode;
import cn.com.duiba.spider.util.maiquan.exception.MaiQuanSpiderException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class AbstractSpider {
    private static final String URL_REGEX = "(https?|http)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";

    protected AbstractSpider() {
    }

    protected abstract ContentSource getContentSource();

    protected String doRequestString(RequestParam param) {
        return this.doRequest(param).body();
    }

    protected JSONObject doRequestJSON(RequestParam param) {
        return JSON.parseObject((String)this.doRequest(param).body());
    }

    protected Document doRequestDocument(RequestParam param) {
        try {
            return this.doRequest(param).parse();
        }
        catch (IOException e) {
            throw new MaiQuanSpiderException(ErrorCode.E003, (Throwable)e);
        }
    }

    protected Connection.Response doRequest(RequestParam param) {
        Connection connection = this.buildConnection(param);
        try {
            return connection.execute();
        }
        catch (SocketTimeoutException e) {
            throw new MaiQuanSpiderException(ErrorCode.E006, (Throwable)e);
        }
        catch (IOException e) {
            throw new MaiQuanSpiderException(ErrorCode.E002, (Throwable)e);
        }
    }

    private Connection buildConnection(RequestParam param) {
        this.checkParam(param);
        Connection connect = Jsoup.connect((String)param.getUrl()).method(param.getMethod()).ignoreHttpErrors(true).ignoreContentType(true).timeout(5000);
        if (param.getHeaders() != null) {
            connect.headers(param.getHeaders());
        }
        if (param.getCookies() != null) {
            connect.cookies(param.getCookies());
        }
        if (param.getBody() != null) {
            connect.data(param.getBody());
        }
        if (param.isProxy()) {
            connect.proxy(param.getHost(), param.getPort());
        }
        if (param.isSSL()) {
            connect.sslSocketFactory(param.getSslSocketFactory());
        }
        if (param.isRedirect()) {
            connect.followRedirects(true);
        }
        return connect;
    }

    public abstract DefaultDto unitedStatesSmash(RequestParam var1);

    public DefaultDto smashOnErrorWithUnknown(RequestParam param) {
        try {
            return this.unitedStatesSmash(param);
        }
        catch (Exception e) {
            AbstractSpider unknown = ContentSource.UNKNOWN.getSpider();
            if (this.getContentSource().getSpider() != unknown) {
                return unknown.unitedStatesSmash(param);
            }
            throw e;
        }
    }

    protected abstract void checkHost(String var1);

    protected void checkParam(RequestParam param) {
        String host;
        if (param == null) {
            throw new MaiQuanSpiderException(ErrorCode.E001.getCode(), "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)param.getUrl())) {
            throw new MaiQuanSpiderException(ErrorCode.E001.getCode(), "\u722c\u53d6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Pattern pattern = Pattern.compile(URL_REGEX);
        if (!pattern.matcher(host = StringUtils.splitByWholeSeparator((String)param.getUrl(), (String)"?")[0]).matches()) {
            throw new MaiQuanSpiderException(ErrorCode.E001.getCode(), "\u722c\u53d6\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        this.checkHost(param.url);
        if (param.isProxy() && (StringUtils.isBlank((String)param.getHost()) || !pattern.matcher(param.getHost()).matches())) {
            throw new MaiQuanSpiderException(ErrorCode.E001.getCode(), "\u4ee3\u7406\u6a21\u5f0f\u4e0b,\u4ee3\u7406host\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.isSSL() && param.getSslSocketFactory() == null) {
            throw new MaiQuanSpiderException(ErrorCode.E001.getCode(), "\u6307\u5b9assl\u8bc1\u4e66\u65f6,sslSocketFactory\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static class RequestParam {
        private String url;
        private Connection.Method method;
        private Map<String, String> headers = Maps.newHashMap();
        private Map<String, String> cookies;
        private Map<String, String> body;
        private boolean isProxy;
        private String host;
        private int port;
        private boolean isSSL;
        private SSLSocketFactory sslSocketFactory;
        private boolean redirect;

        private RequestParam() {
            this.headers.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36");
            this.redirect = true;
        }

        public RequestParam(String url) {
            this();
            this.url = url;
            this.method = Connection.Method.GET;
        }

        public RequestParam(String url, Connection.Method method) {
            this();
            this.url = url;
            this.method = method;
        }

        public boolean isRedirect() {
            return this.redirect;
        }

        public void setRedirect(boolean redirect) {
            this.redirect = redirect;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Connection.Method getMethod() {
            return this.method;
        }

        public void setMethod(Connection.Method method) {
            this.method = method;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public Map<String, String> getCookies() {
            return this.cookies;
        }

        public void setCookies(Map<String, String> cookies) {
            this.cookies = cookies;
        }

        public Map<String, String> getBody() {
            return this.body;
        }

        public void setBody(Map<String, String> body) {
            this.body = body;
        }

        public boolean isProxy() {
            return this.isProxy;
        }

        public void setProxy(boolean proxy) {
            this.isProxy = proxy;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isSSL() {
            return this.isSSL;
        }

        public void setSSL(boolean SSL) {
            this.isSSL = SSL;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }
    }
}

