/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class UnknownSpider
extends AbstractSpider {
    private static final String DEFAULT_ICON = "https://yun.duiba.com.cn/magiclink_icon.png";
    public static final UnknownSpider SPIDER = new UnknownSpider();

    private UnknownSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.UNKNOWN;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        Document document = this.doRequestDocument(param);
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), this.getContentSource().getCode());
        defaultDto.setPostTitle(document.title());
        ArrayList icons = Lists.newArrayList();
        Elements links = document.head().select("link");
        links.forEach(link -> {
            String rel = link.attr("rel");
            if (StringUtils.contains((String)rel, (String)"icon")) {
                String href = link.attr("href");
                if (StringUtils.contains((String)href, (String)"//") || StringUtils.contains((String)href, (String)"http://") || StringUtils.contains((String)href, (String)"https://")) {
                    if (StringUtils.startsWithIgnoreCase((String)href, (String)"//")) {
                        href = "http:" + href;
                    }
                    icons.add(href);
                } else {
                    String host = StringUtils.splitByWholeSeparator((String)StringUtils.splitByWholeSeparator((String)param.getUrl(), (String)"//")[1], (String)"/")[0];
                    href = "http://" + host + href;
                    icons.add(href);
                }
            }
        });
        defaultDto.setSourceId(UUIDUtils.createUUID());
        defaultDto.setImageList(icons);
        if (StringUtils.isBlank((String)defaultDto.getPostTitle())) {
            defaultDto.setPostTitle(param.getUrl());
        }
        if (CollectionUtils.isEmpty(defaultDto.getImageList())) {
            defaultDto.getImageList().add(DEFAULT_ICON);
        }
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
    }
}

