package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import java.util.Objects;

@Slf4j
@Component
public class CustomRequestInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        Boolean traceContext = SamplingThreadLocal.getContext().get();
        if (Objects.isNull(traceContext)) {
            return;
        }
        log.info("服务2, 是否需要打印日志{}", traceContext);
        template.header(TraceConstant.RPC_TRACE_CONTEXT, traceContext.toString());

    }

}
