package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.openfeign.FeignClient;
import java.util.Objects;

@Slf4j
@Configuration
@ConditionalOnClass({FeignClient.class})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class DuibaRpcContextParamsInterceptor extends HandlerInterceptorAdapter {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceContext = request.getHeader(TraceConstant.RPC_TRACE_CONTEXT);
        if (StringUtils.isBlank(traceContext)) {
            return true;
        }
        log.info("服务1, {}", traceContext);
        SamplingThreadLocal.set(Objects.equals("true", traceContext));
        return true;
    }
}
