package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import javax.annotation.Resource;
import javax.servlet.Servlet;

@Configuration
@ConditionalOnClass({FeignClient.class})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@Import(DuibaRpcContextParamsInterceptor.class)
public class RpcContextParamsInterceptorConfig {

    @Bean
    public InterceptorRegisterConfig interceptorRegister(){
        return new InterceptorRegisterConfig();
    }

    static class InterceptorRegisterConfig implements WebMvcConfigurer, Ordered {

        @Resource
        private DuibaRpcContextParamsInterceptor interceptor;

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(interceptor).addPathPatterns("/**");
        }

        @Override
        public int getOrder() {
            return -100;
        }
    }

}