package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class SamplingThreadLocal {

    private static final Random random = new Random();

    private static final Map<Integer, Integer> map = new ConcurrentHashMap<>();

    private static final TransmittableThreadLocal<Boolean> context = new TransmittableThreadLocal<>();

    public static TransmittableThreadLocal<Boolean> getContext() {
        return context;
    }

    public static void set(Integer adxType, Integer newSamplingNum) {
        if (Objects.isNull(adxType)) {
            context.set(false);
            return;
        }

        if (Objects.isNull(newSamplingNum)) {
            map.put(adxType, 1000);
            context.set(random.nextInt(1000) == 0);
            return;
        }

        if (!map.containsKey(adxType)) {
            map.put(adxType, newSamplingNum);
            context.set(random.nextInt(newSamplingNum) == 0);
            return;
        }
        Integer oldSamplingNum = map.get(adxType);
        if (Objects.equals(newSamplingNum, oldSamplingNum)) {
            context.set(random.nextInt(oldSamplingNum) == 0);
            return;
        }

        map.put(adxType, newSamplingNum);
        context.set(random.nextInt(newSamplingNum) == 0);
    }

    public static void set(boolean flag) {
        context.set(flag);
    }


}
