package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import java.util.Objects;

@Slf4j
@Component
public class CustomRequestInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        Boolean traceContext = LogSamplerContext.getContext().get();
        if (Objects.isNull(traceContext)) {
            return;
        }
        template.header(TraceConstant.RPC_TRACE_CONTEXT, traceContext.toString());

    }

}
