package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import java.util.Objects;

@Component
public class LogSampler {

    private static final Logger logger = LoggerFactory.getLogger(LogSampler.class);

    public void startSampling(Integer samplingRate){
        LogSamplerContext.set(samplingRate);
    }

    public void info(String format, Object... arguments) {
        TransmittableThreadLocal<Boolean> context = LogSamplerContext.getContext();
        if (Objects.isNull(context)) {
            return;
        }

        if (Objects.isNull(context.get())) {
            return;
        }

        if (context.get()) {
            logger.info(format, arguments);
        }

    }
}
