package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import java.util.Random;

public class LogSamplerContext {

    private static final Random random = new Random();

    private static final TransmittableThreadLocal<Boolean> context = new TransmittableThreadLocal<>();

    static TransmittableThreadLocal<Boolean> getContext() {
        return context;
    }

    static void set(Integer samplingRate) {
        if (Objects.isNull(samplingRate)) {
            context.set(false);
            return;
        }

        context.set(random.nextInt(samplingRate) == 0);
    }

    static void set(boolean flag) {
        context.set(flag);
    }

}
