/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.service.impl;

import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.spring.boot.starter.autoconfigure.service.AlgoTFModelFactory;
import cn.com.duiba.spring.boot.starter.autoconfigure.service.AlgoTFModelProxy;
import cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.service.impl.AlgoTFModelProxyImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AlgoTFModelFactoryImpl
implements AlgoTFModelFactory {
    private static final Logger log = LoggerFactory.getLogger(AlgoTFModelFactoryImpl.class);
    private final AtomicInteger atomicInteger = new AtomicInteger(0);
    private final Map<String, AlgoTFModelProxy> proxyMap = new ConcurrentHashMap<String, AlgoTFModelProxy>();

    @Override
    public LocalTFModel getTFModel(String tfKey) {
        if (this.proxyMap.containsKey(tfKey)) {
            AlgoTFModelProxy algoTFModelProxy = this.proxyMap.get(tfKey);
            return algoTFModelProxy.chooseTFModel();
        }
        if (this.atomicInteger.compareAndSet(0, 1)) {
            AlgoTFModelProxyImpl proxy;
            try {
                proxy = new AlgoTFModelProxyImpl(tfKey);
                this.proxyMap.putIfAbsent(tfKey, proxy);
            }
            catch (Exception e) {
                log.warn("AlgoTFModelProxy init error", (Throwable)e);
                this.atomicInteger.set(0);
                return null;
            }
            this.atomicInteger.set(0);
            return proxy.chooseTFModel();
        }
        return null;
    }

    @Scheduled(fixedDelay=120000L)
    void updateTFModelTask() {
        if (MapUtils.isEmpty(this.proxyMap)) {
            return;
        }
        this.closeTFModels();
        if (this.isExistLoadingTFModels()) {
            return;
        }
        this.updateTFModels();
    }

    private void closeTFModels() {
        for (Map.Entry<String, AlgoTFModelProxy> entry : this.proxyMap.entrySet()) {
            AlgoTFModelProxy algoTFModelProxy = entry.getValue();
            if (Objects.isNull(algoTFModelProxy)) continue;
            algoTFModelProxy.closeTFModel();
            if (!algoTFModelProxy.needFlush()) continue;
            this.proxyMap.remove(entry.getKey());
        }
    }

    private boolean isExistLoadingTFModels() {
        for (AlgoTFModelProxy algoTFModelProxy : this.proxyMap.values()) {
            if (Objects.isNull(algoTFModelProxy) || !algoTFModelProxy.hasTwoRunningModel()) continue;
            return true;
        }
        return false;
    }

    private void updateTFModels() {
        ArrayList<AlgoTFModelProxy> algoTFModelProxies = new ArrayList<AlgoTFModelProxy>(this.proxyMap.values());
        algoTFModelProxies.sort(Comparator.comparingLong(x -> ((AlgoTFModelProxyImpl)x).getTfModelUpdateTime()));
        for (AlgoTFModelProxy algoTFModelProxy : algoTFModelProxies) {
            if (Objects.isNull(algoTFModelProxy) || !algoTFModelProxy.updateTFModel()) continue;
            return;
        }
    }
}

