/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerContext;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerTracer;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.TraceConstant;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CustomRequestInterceptor.class);

    @Autowired
    public void apply(RequestTemplate template) {
        LogSamplerTracer logSamplerTracer = (LogSamplerTracer)LogSamplerContext.getContext().get();
        if (Objects.isNull(logSamplerTracer) || Objects.isNull(logSamplerTracer.getPrintLogFlag())) {
            return;
        }
        if (logSamplerTracer.getPrintLogFlag().booleanValue()) {
            template.header(TraceConstant.RPC_ADX_TRACE_ID, new String[]{logSamplerTracer.getAdxTraceId()});
        }
        template.header(TraceConstant.RPC_TRACE_CONTEXT, new String[]{logSamplerTracer.getPrintLogFlag().toString()});
    }
}

