/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerContext;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerTracer;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.TraceConstant;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer", "provider"}, order=-2000)
public class DubboTraceContextFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboTraceContextFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        boolean isConsumerSide = Objects.equals(sideKey, "consumer");
        if (isConsumerSide) {
            RpcContext.getContext().setAttachment(TraceConstant.DUBBO_TRACE_CONTEXT, String.valueOf(((LogSamplerTracer)LogSamplerContext.getContext().get()).getPrintLogFlag()));
            RpcContext.getContext().setAttachment(TraceConstant.DUBBO_ADX_TRACE_ID, String.valueOf(((LogSamplerTracer)LogSamplerContext.getContext().get()).getAdxTraceId()));
        } else {
            String traceContext = RpcContext.getContext().getAttachment(TraceConstant.DUBBO_TRACE_CONTEXT);
            String traceId = RpcContext.getContext().getAttachment(TraceConstant.DUBBO_ADX_TRACE_ID);
            LogSamplerContext.set(Objects.equals("true", traceContext), traceId);
        }
        try {
            return invoker.invoke(invocation);
        }
        catch (Exception e) {
            log.warn("DubboTraceContextFilter invoke warn");
            return null;
        }
    }
}

