/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerContext;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerTracer;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogSampler {
    @Autowired
    private LogSamplerContext logSamplerContext;
    private static final Logger logger = LoggerFactory.getLogger(LogSampler.class);

    public void startSampling(Integer samplingRate) {
        this.logSamplerContext.set(samplingRate);
    }

    public void info(String format, Object ... arguments) {
        TransmittableThreadLocal<LogSamplerTracer> context = LogSamplerContext.getContext();
        if (Objects.isNull(context) || Objects.isNull(context.get())) {
            return;
        }
        LogSamplerTracer logSamplerTracer = (LogSamplerTracer)context.get();
        if (logSamplerTracer.getPrintLogFlag().booleanValue()) {
            logger.info("traceId-" + logSamplerTracer.getAdxTraceId() + "\uff0c" + format, arguments);
        }
    }
}

