/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import brave.Tracer;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.LogSamplerTracer;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class LogSamplerContext {
    @Resource
    private Tracer tracer;
    private static final Random random = new Random();
    private static final TransmittableThreadLocal<LogSamplerTracer> logSamplerTracerThreadLocal = new TransmittableThreadLocal();

    static TransmittableThreadLocal<LogSamplerTracer> getContext() {
        return logSamplerTracerThreadLocal;
    }

    void set(Integer samplingRate) {
        LogSamplerTracer logSamplerTracer = new LogSamplerTracer();
        if (Objects.isNull(samplingRate)) {
            logSamplerTracer.setPrintLogFlag(false);
            logSamplerTracerThreadLocal.set((Object)logSamplerTracer);
            return;
        }
        if (random.nextInt(samplingRate) == 0) {
            logSamplerTracer.setPrintLogFlag(true);
            logSamplerTracer.setAdxTraceId(String.valueOf(this.tracer.currentSpan().context().traceId()));
            logSamplerTracerThreadLocal.set((Object)logSamplerTracer);
            return;
        }
        logSamplerTracer.setPrintLogFlag(false);
        logSamplerTracerThreadLocal.set((Object)logSamplerTracer);
    }

    static void set(boolean flag, String traceId) {
        LogSamplerTracer logSamplerTracer = new LogSamplerTracer();
        logSamplerTracer.setPrintLogFlag(flag);
        logSamplerTracer.setAdxTraceId(traceId);
        logSamplerTracerThreadLocal.set((Object)logSamplerTracer);
    }
}

