package cn.com.duiba.spring.boot.starter.autoconfigure.aaa;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;

@Slf4j
@Aspect
@Component
@EnableAspectJAutoProxy
public class LogInfoAspect {

    @Pointcut("target(ch.qos.logback.classic.Logger)")
    public void pointcut1() {}

    @Pointcut("execution(* ch.qos.logback.classic.Logger.info(..))")
    public void pointcut2() {}


    @Around(value = "pointcut1()")
    public Object process1(ProceedingJoinPoint point) throws Throwable {
        log.info("aaaa");
        return point.proceed(point.getArgs());
    }

    @Around(value = "pointcut2()")
    public Object process2(ProceedingJoinPoint point) throws Throwable {
        log.info("bbbb");
        return point.proceed(point.getArgs());
    }

//    @Around(value = "pointcut()")
//    public Object process(ProceedingJoinPoint point) throws Throwable {
//        if (!Objects.equals(((MethodSignature)point.getSignature()).getMethod().getName(), "info")) {
//            return point.proceed(point.getArgs());
//        }
//
//        if (Objects.isNull(PrintLogUtils.context)) {
//            return point.proceed(point.getArgs());
//        }
//
//        if (PrintLogUtils.context.get()) {
//            return point.proceed(point.getArgs());
//        }
//        return null;
//    }



}
