package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class SamplingThreadLocal {

    private static final Random random = new Random();

    private static final Map<Integer, Integer> map = new ConcurrentHashMap<>();

    private static final TransmittableThreadLocal<Boolean> context = new TransmittableThreadLocal<>();

    static final InheritableThreadLocal<Boolean> INHERITABLE = new InheritableThreadLocal<>();

    public static TransmittableThreadLocal<Boolean> getContext() {
        return context;
    }

    public static void set(Integer adxType, Integer newSamplingNum) {
        INHERITABLE.set(true);
        if (Objects.isNull(adxType)) {
            context.set(false);
            return;
        }

        int randomNum;
        if (Objects.isNull(newSamplingNum)) {
            map.put(adxType, 1000);
            randomNum = random.nextInt(1000);
            context.set(randomNum == 0);
            return;

        }

        if (!map.containsKey(adxType)) {
            map.put(adxType, newSamplingNum);
            randomNum = random.nextInt(newSamplingNum);
            context.set(randomNum == 0);
            return;
        }
        Integer oldSamplingNum = map.get(adxType);
        if (Objects.equals(newSamplingNum, oldSamplingNum)) {
            randomNum = random.nextInt(oldSamplingNum);
            context.set(randomNum == 0);
            return;
        }

        map.put(adxType, newSamplingNum);
        randomNum = random.nextInt(newSamplingNum);
        context.set(randomNum == 0);
    }

    public static void set(boolean flag) {
        context.set(flag);
    }



}
