/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import cn.com.duiba.spring.boot.starter.autoconfigure.trace.SamplingThreadLocal;
import cn.com.duiba.spring.boot.starter.autoconfigure.trace.TraceConstant;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnClass(value={FeignClient.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class DuibaRpcContextParamsInterceptor
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceContext = request.getHeader(TraceConstant.RPC_TRACE_CONTEXT);
        if (StringUtils.isBlank((CharSequence)traceContext)) {
            return true;
        }
        SamplingThreadLocal.set(Objects.equals("true", traceContext));
        return true;
    }
}

