/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.web.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.web.factory.SsoBeanFactory;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.SsoFilter;
import cn.com.duiba.sso.api.web.logger.SsoLogger;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class SsoSystemAware
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private SsoContext context;
    private SystemEnum system;
    private String defaultRedirectUrl = "/";
    private String ssoSystemUrl;

    @PostConstruct
    public void init() {
        SsoSystemProperties properties = new SsoSystemProperties();
        BeanUtils.copyProperties((Object)this, (Object)properties);
        this.context = new SsoContext(this.applicationContext, properties);
        SsoBeanFactory beanFactory = SsoBeanFactory.newInstance(this.context);
        this.context.setSsoBeanFactory(beanFactory);
        SsoFilter.setSsoContext(this.context);
        RequestTool.setSsoContext(this.context);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Pointcut(value="@annotation(cn.com.duiba.sso.api.web.annotation.SsoLoggerMethod)")
    public void logger() {
    }

    @Before(value="logger()")
    public void loggerBefore(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        SsoLoggerMethod ssoLoggerMethod = (SsoLoggerMethod)AnnotationUtils.findAnnotation((Method)method, SsoLoggerMethod.class);
        String template = ssoLoggerMethod.value();
        String group = ssoLoggerMethod.group();
        SsoLoggerTheadContext context = new SsoLoggerTheadContext();
        context.setTemplate(template);
        context.setGroup(group);
        SsoLogger.setSsoLoggerTheadContext(context);
    }

    @After(value="logger()")
    public void loggerAfter() {
        SsoLogger.flush();
    }

    public SsoContext getSsoContext() {
        return this.context;
    }

    public SystemEnum getSystem() {
        return this.system;
    }

    public void setSystem(SystemEnum system) {
        this.system = system;
    }

    public String getDefaultRedirectUrl() {
        return this.defaultRedirectUrl;
    }

    public void setDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
    }

    public String getSsoSystemUrl() {
        return this.ssoSystemUrl;
    }

    public void setSsoSystemUrl(String ssoSystemUrl) {
        this.ssoSystemUrl = ssoSystemUrl;
    }
}

