package cn.com.duiba.sso.api;

import java.lang.reflect.Method;

import javax.annotation.PostConstruct;

import cn.com.duiba.sso.api.web.tool.RequestTool;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.web.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.web.factory.SsoBeanFactory;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.SsoFilter;
import cn.com.duiba.sso.api.web.logger.SsoLogger;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;

/**
 * Created by liuyao on 2017/5/12.
 * Sso客户端启动入口
 */
@Aspect
public class SsoSystemAware implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    private SsoContext context;

    private SystemEnum system;

    private String defaultRedirectUrl = "/";

    private String ssoSystemUrl;

    /**
     * 启动方法
     */
    @PostConstruct
    public void init(){
        SsoSystemProperties properties = new SsoSystemProperties();
        BeanUtils.copyProperties(this,properties);
        //初始化SSO私有容器
        context = new SsoContext(applicationContext,properties);
        SsoBeanFactory beanFactory = SsoBeanFactory.newInstance(context);
        context.setSsoBeanFactory(beanFactory);
        //初始化核心拦截器
        SsoFilter.setSsoContext(context);
        RequestTool.setSsoContext(context);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext){
        this.applicationContext = applicationContext;
    }

    /*********************管理员操作日志切面*********************/

    @Pointcut("@annotation(cn.com.duiba.sso.api.web.annotation.SsoLoggerMethod)")
    public void logger(){}

    @Before("logger()")
    public void loggerBefore(JoinPoint point){
        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Method method = methodSignature.getMethod();
        SsoLoggerMethod ssoLoggerMethod = AnnotationUtils.findAnnotation(method,SsoLoggerMethod.class);
        String template = ssoLoggerMethod.value();
        String group = ssoLoggerMethod.group();

        SsoLoggerTheadContext context = new SsoLoggerTheadContext();
        context.setTemplate(template);
        context.setGroup(group);
        SsoLogger.setSsoLoggerTheadContext(context);
    }

    @After("logger()")
    public void loggerAfter(){
        SsoLogger.flush();
    }

    /*********************管理员操作日志切面——END*********************/

    /**
     * 获取SSO容器
     * @return
     */
    public SsoContext getSsoContext(){
        return context;
    }

    public SystemEnum getSystem() {
        return system;
    }

    public void setSystem(SystemEnum system) {
        this.system = system;
    }

    public String getDefaultRedirectUrl() {
        return defaultRedirectUrl;
    }

    public void setDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
    }

    public String getSsoSystemUrl() {
        return ssoSystemUrl;
    }

    public void setSsoSystemUrl(String ssoSystemUrl) {
        this.ssoSystemUrl = ssoSystemUrl;
    }
}
