package cn.com.duiba.sso.api.web.filter.filterhandler.handler;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;

import java.io.IOException;
import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/12.
 * 远程权限拦截系统(未迁移)
 */
@SsoComponent
public class AuthorityFilterHandler extends SsoFilterHandler {

    private SystemEnum system;
    private Splitter spl = Splitter.on("/").trimResults().omitEmptyStrings();
    @Override
    public Integer getOrder() {
        return -99;
    }

    @Override
    public void setContext(SsoContext context) {
        system = context.getSsoSystemProperties().getSystem();
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        AdminDto admin = RequestTool.getAdmin();
        if(!admin.getCompanyEnumSet().contains(system)){
            throw new SsoException("尊敬的"+admin.getName()+",你对"+system.getName()+"的执着给我们留下了深刻的印象,不过相关领导说你不能进");
        }
//        HttpServletRequest request = RequestTool.getRequest();
//        HttpServletResponse response = RequestTool.getResponse();
//
//        Long adminId = RequestTool.getAdminId();
//        String accept = request.getHeader("Accept");
//        String url = request.getRequestURI();
//        List<String> list = spl.splitToList(url);
//        if(list.size()>2){
//            StringBuffer sb = new StringBuffer();
//            sb.append("/").append(list.get(0)).append("/").append(list.get(1));
//            url = sb.toString();
//        }
//
//        if(PermissionSystemService.isSuperManager(adminId)){//超级管理员直接放行
//            try {
//                chain.doFilter(request, response);
//            } catch (IOException e) {
//                e.printStackTrace();
//            } catch (ServletException e) {
//                e.printStackTrace();
//            }
//            return true;
//        }
//        if(Objects.equal(null, request.getSession().getAttribute(PermissionSystemService.URL_Black_Key))){
//            PermissionSystemService.setURLBlackSetInSession(adminId,  request.getSession());
//        }
//        @SuppressWarnings("unchecked")
//        Set<String> urlBlackSet = (Set<String>) request.getSession().getAttribute(PermissionSystemService.URL_Black_Key);
//        if(!urlBlackSet.contains(url.toLowerCase())){
//            try {
//                chain.doFilter(request, response);
//            } catch (IOException e) {
//                e.printStackTrace();
//            } catch (ServletException e) {
//                e.printStackTrace();
//            }
//            return true;
//        }else{
//            if(accept.contains("json")){
//                JSONObject json = new JSONObject();
//                json.put("success", false);
//                json.put("message", "权限拦截：无权访问");
//                response.setHeader("Content-Type", "application/json;charset=UTF-8");
//                try {
//                    response.getWriter().write(json.toJSONString());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//                return false;
//            }
//            if(accept.contains("html")){//重定向到无权页面
//                try {
//                    request.getRequestDispatcher("/admin/nopower").forward(request, response);
//                } catch (ServletException e) {
//                    e.printStackTrace();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//                return false;
//            }
//            try {
//                response.getWriter().write("无权访问");
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//        }
        return true;
    }
}
