package cn.com.duiba.sso.api.web.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.PermissionDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by liuyao on 2017/5/11.
 */
public class RequestTool {
    private static ThreadLocal<RequestTool> local = new ThreadLocal<>();
    private static SsoContext context;

    private static RemoteAdminService remoteAdminService;
    private static RemotePermissionService remotePermissionService;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private RequestParams params;



    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response){
        if(request==null) throw new SsoRunTimeException("RequestTool注入request为空");
        if(response==null) throw new SsoRunTimeException("RequestTool注入response为空");
        RequestTool tool = new RequestTool();
        tool.request = request;
        tool.response = response;
        tool.params = RequestParams.parse(request);
        local.set(tool);
    }

    public static void setSsoContext(SsoContext context){
        RequestTool.remoteAdminService = context.getBean(RemoteAdminService.class);
        RequestTool.remotePermissionService = context.getBean(RemotePermissionService.class);
    }

    private static RequestTool get(){
        if(local.get()==null) throw new SsoRunTimeException("请在登录拦截器中调用setRequestInThreadLocal");
        return local.get();
    }

    /**
     * RequestTool中的变量只能在当前线程中使用,当启用异步线程的时候,使用此方法复制一个新的封装对象,防止空指针
     * @return
     */
    public static RequestParams getRequestParams(){
        return get().params.clone();
    }

    public static HttpServletResponse getResponse(){
        return get().response;
    }

    public static HttpServletRequest getRequest(){
        return get().request;
    }

    public static void removeRequestInThreadLocal(){
        local.remove();
    }

    public static Long getAdminId(){
        AdminDto admin = getAdmin();
        return admin.getId();
    }

    public static AdminDto getAdmin() {
        RequestTool tool = RequestTool.get();
        return tool.params.getAdmin();
    }

    public static void setAdmin(AdminDto admin) {
        RequestTool tool = RequestTool.get();
        tool.params.setAdmin(admin);
    }

    public static  List<AdminDto> GetAdmins(String roleName, SystemEnum system)throws RuntimeException{
        if(system == null){
            throw new IllegalArgumentException("system");
        }
        int systemId = system.getId().intValue();
        DubboResult<List<AdminDto>> result = RequestTool.remoteAdminService.findAdmins(systemId,roleName);
        return result.getResult();
    }

    public static void addCookie(Cookie cookie){
        if(cookie==null){
            return;
        }
        RequestTool tool = RequestTool.get();
        tool.params.addCookie(cookie.getName(),cookie.getValue());
        tool.response.addCookie(cookie);
    }

    public static String getUrl(){
        return get().params.getUrl();
    }

    public static boolean isHttpsRequest(){
        HttpServletRequest request= get().request;
        return "true".equals(request.getHeader("Use-Https"));
    }

    public static String getCookie(String name){
        RequestTool tool = RequestTool.get();
        return tool.params.getCookie(name);
    }

    /**
     * 提取request中的参数
     * @return
     */
    public static Map<String,String> getRequestParamMap(){
        HttpServletRequest request= get().request;
        Map<String, String[]> map=request.getParameterMap();
        Map<String, String> resultMap=new HashMap<>();
        for(Map.Entry<String, String[]> entry :map.entrySet()){
            resultMap.put(entry.getKey(), entry.getValue()[0]);
        }
        return resultMap;
    }

    public static Boolean isAsynchronousRequests(){
        HttpServletRequest request= get().request;
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return (StringUtils.isNoneBlank(re) || StringUtils.isNoneBlank(accept) && accept.contains("json"));
    }

    public static String getIp(){
        RequestTool tool = RequestTool.get();
        return tool.params.getIp();
    }

    public static Boolean isLocalHost(){
        RequestTool tool = RequestTool.get();
        return Objects.equal(tool.params.getIp(),RequestParams.LOCALHOST_IP);
    }

    public static void googleVerify(String code) throws SsoException{
        RequestTool tool = RequestTool.get();
        Long adminId = tool.getAdminId();
        DubboResult<Boolean> result = RequestTool.remoteAdminService.googleVerify(adminId,code);
        if(!result.isSuccess()){
            throw new SsoException(result.getMsg());
        }
    }


    public static List<PermissionDto> GetPermissions(Long adminId,Long systemId) throws RuntimeException{
        DubboResult<List<PermissionDto>> result = RequestTool.remotePermissionService.getPermissions(adminId.intValue(),systemId.intValue());
        return result.getResult();
    }
    /**
     * 获取令牌
     * @return
     */
    public static String findTicket(){
        String ticketForUrl = getRequestParamMap().get(CookieUtil.LOGIN_COOKIE_NAME);
        if(StringUtils.isNotBlank(ticketForUrl)){
            return ticketForUrl;
        }
        return CookieUtil.getCookie(CookieUtil.LOGIN_COOKIE_NAME);
    }

}
