package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.params.CreateAdminParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2017/5/12.
 */
public interface RemoteAdminService {
    /**
     * 获取管理员
     * @param id
     * @return
     */
    DubboResult<AdminDto> findAdmin(Long id);


    /**
     * 查询所有的管理员
     * @return
     */
    DubboResult<List<AdminDto>> findAllAdmin();

    /**
     * 根据系统Id或角色名来查询所有的管理员，roleName为空时查询系统所有admin
     * @return
     */
    DubboResult<List<AdminDto>> findAdmins(int systemId,String roleName);
    /**
     * 更新TokenSecret
     * @param adminId
     * @param tokenSecret
     * @return
     */
    DubboResult<Boolean> resetTokenSecret(Long adminId,String tokenSecret);

    /**
     * 验证谷歌动态码
     * @param adminId
     * @param code
     * @return
     */
    DubboResult<Boolean> googleVerify(Long adminId,String code);

    /**
     * 创建管理员
     * @param params
     * @return
     */
    DubboResult<Long> createAdmin(CreateAdminParams params);

    /**
     * 批量查询管理员
     * @param ids
     * @return
     */
    DubboResult<List<AdminDto>> findAdminByIds(List<Long> ids);

}
