package cn.com.duiba.sso.api.web.factory;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.web.annotation.BizEventListener;
import cn.com.duiba.sso.api.web.factory.SsoBeanFactory;
import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;
import cn.com.duiba.wolf.utils.ClassUtils;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import org.springframework.context.ApplicationContext;

import com.google.common.collect.Maps;

/**
 * Created by liuyao on 2017/5/11.
 * 管理SSO对外所有的接口
 */
public class SsoContext {

    private SsoBeanFactory ssoBeanFactory;

    private SsoSystemProperties properties;

    private ApplicationContext applicationContext;

    public SsoContext(ApplicationContext applicationContext, SsoSystemProperties properties){
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    public void setSsoBeanFactory(SsoBeanFactory ssoBeanFactory){
        this.ssoBeanFactory = ssoBeanFactory;
        this.ssoBeanFactory.scan();
    }

    /**
     * 在产品类内部进行调用
     * @param clazz
     * @param <T>
     * @return
     */
    public <T> T getBean(Class<T> clazz){
        T bean = ssoBeanFactory.getBean(clazz);
        if(Objects.equal(bean,null)){
            throw new SsoRunTimeException("SSO系统依赖的Bean:"+clazz.getName()+"不存在");
        }
        return bean;
    }

    public SsoSystemProperties getSsoSystemProperties() {
        return properties;
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public Set<Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return ssoBeanFactory.getBeansWithAnnotation(annotationType);
    }
}
