package cn.com.duiba.sso.api.web.filter.filterhandler;

import javax.servlet.FilterChain;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.factory.SsoBeanAware;

/**
 * Created by liuyao on 2017/5/11.
 * SSO 拦截行为拓展接口
 * 职责链设计模式
 */
public abstract class SsoFilterHandler implements SsoBeanAware {

    public static final Integer DEFAULT_ORDER = 0;

    /**
     * 获取排列权重 小于0 则在chain.doFilter 之前执行,反之则之后执行
     * @return
     */
    public abstract Integer getOrder();

    /**
     * getOrder()大于0是不要调用chain.ofFilter
     *
     * @param chain
     * @throws SsoException
     */
    public abstract Boolean doHandler(FilterChain chain) throws SsoException;

}
