package cn.com.duiba.sso.api.web.filter.filterhandler.handler;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.tool.RequestTool;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by liuyao on 2017/5/11.
 */
@SsoComponent
public class DefaultFilterHandler extends SsoFilterHandler {

    @Override
    public Integer getOrder() {
        return SsoFilterHandler.DEFAULT_ORDER;
    }

    @Override
    public void setContext(SsoContext manager) {

    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        HttpServletResponse response = RequestTool.getResponse();
        HttpServletRequest request = RequestTool.getRequest();
        try{
            chain.doFilter(request,response);
        }catch (Exception e){
            throw new SsoException(e);
        }
        return true;
    }
}
