package cn.com.duiba.sso.api.web.filter.filterhandler.handler;

import javax.servlet.FilterChain;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Objects;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.tool.CookieUtil;
import cn.com.duiba.sso.api.web.tool.RequestTool;

import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * Created by liuyao on 2017/5/11.
 * 单点登录拦截系统
 */
@SsoComponent
public class LoginFilterHandler extends SsoFilterHandler {

    private RemoteSSOService remoteSSOService;
    private String ssoSystemUrl;
    private String redirectUrl;
    private SystemEnum system;

    @Override
    public Integer getOrder() {
        return -100;
    }

    @Override
    public void setContext(SsoContext context) {
        remoteSSOService = context.getBean(RemoteSSOService.class);
        ssoSystemUrl = context.getSsoSystemProperties().getSsoSystemUrl();
        system = context.getSsoSystemProperties().getSystem();
        redirectUrl=context.getSsoSystemProperties().getDefaultRedirectUrl();
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        String ticket = RequestTool.findTicket();
        DubboResult<AdminDto> adminIdRes = remoteSSOService.verifyTicketToAdmin(ticket);
        //未登录状态
        if(!adminIdRes.isSuccess() || Objects.equal(null,adminIdRes.getResult())){
            try{
                if(RequestTool.isAsynchronousRequests()){
                    RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JSONObject model = new JSONObject();
                    model.put("success",false);
                    model.put("notLogin",true);
                    model.put("message",adminIdRes.getMsg());
                    RequestTool.getResponse().getWriter().write(model.toJSONString());
                }else{
                    //附上当前请求地址,重定向到SSO登录页
                    String url;
                    if("/".equals(redirectUrl)){
                        url = URLEncoder.encode(RequestTool.getUrl(),"utf-8");
                    }
                    else{
                        String scheme = RequestTool.getRequest().getScheme();
                        String serverName = RequestTool.getRequest().getServerName();
                        int port = RequestTool.getRequest().getServerPort();
                        String domainUrl = scheme + "://" + serverName + ":" + port;
                        url = URLEncoder.encode(domainUrl + redirectUrl,"utf-8");
                    }
                    RequestTool.getResponse().sendRedirect(getLoginRedirectUrl(url));
                }
            }catch (Exception e){
                throw new SsoException(e);
            }
            return false;
        }
        AdminDto admin = adminIdRes.getResult();
        //注入adminId
        RequestTool.setAdmin(admin);
        //当通行令牌存在于链接参数中时,则把它持久到cookie中(链接中通行证的参数名和链接中的相同)
        if(RequestTool.getRequestParamMap().containsKey(CookieUtil.LOGIN_COOKIE_NAME)){
            CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);
        }
        return true;
    }



    /**
     * 获取登录重定向地址
     * @param redirect
     * @return
     */
    private String getLoginRedirectUrl(String redirect){
        StringBuilder builder = new StringBuilder();
        builder.append(getLoginUrl()).append("?redirect=").append(redirect);
        builder.append("&system=").append(system.getId());
        return builder.toString();
    }

    private String getLoginUrl(){
        StringBuilder sb = new StringBuilder();
        sb.append(ssoSystemUrl).append("/login");
        return sb.toString();
    }
}
