package cn.com.duiba.sso.api.web.logger.domain;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by liuyao on 2017/6/19.
 */
public class SsoLoggerTheadContext {
    private static final Logger logger = LoggerFactory.getLogger(SsoLoggerTheadContext.class);
    /**
     * 单个线程最多提交的日志总数
     */
    private static final int MAX_LOG_NUM = 1000;

    private String template;
    private String group;

    public List<JSONObject> params = Lists.newArrayList();

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public List<JSONObject> getParams() {
        return params;
    }

    public void addParams(JSONObject param) {
        if(params.size()>MAX_LOG_NUM){
            logger.warn("管理员操作日志提交量已经操过上限:"+MAX_LOG_NUM);
            return;
        }
        this.params.add(param);
    }
}
