package cn.com.duiba.sso.api.web.tool;

import javax.servlet.http.Cookie;

/**
 * Created by liuyao on 2017/5/11.
 */
public class CookieUtil {

    public static final String LOGIN_COOKIE_NAME = "sso_ticket";

    /**
     * 如果是线上环境，对应到.duiba.com.cn；如果是测试环境或者预发环境，通过配置项读取
     * @param name
     * @param value
     * @return
     */
    public static Cookie createCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(24*60*60);
        cookie.setSecure(true);
        return cookie;
    }

    /**
     * 设置cookie
     * @param name
     * @param value
     */
    public static void setCookie(String name, String value) {
        Cookie cookie = createCookie(name, value);
        cookie.setSecure(true);
        RequestTool.addCookie(cookie);
    }

    /**
     * 设置登录令牌
     * @param ticket
     */
    public static void setLoginCookie(String ticket){
        Cookie cookie = createCookie(LOGIN_COOKIE_NAME, ticket);
        cookie.setSecure(true);
        RequestTool.addCookie(cookie);
    }

    public static void deleteCookie(String name){
        Cookie cookie=createCookie(name,null);
        cookie.setMaxAge(0);
        RequestTool.getResponse().addCookie(cookie);
    }

    /**
     * 根据名字获取cookie
     * @param name
     * @return
     */
    public static String getCookie(String name) {
        return RequestTool.getCookie(name);
    }

}
