/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.filter;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.annotation.CanAccess;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.tool.JsonRender;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Controller;

public class SsoFilter
implements Filter {
    private static Set<String> EXCLUDE_PATHS = Sets.newHashSet();
    private static SsoFilterHandlerQueue queue;

    public void init(FilterConfig filterConfig) throws ServletException {
        EXCLUDE_PATHS.add("/favicon.ico");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        response.setCharacterEncoding("UTF-8");
        RequestTool.setRequestInThreadLocal(request, response);
        try {
            String url = request.getRequestURI();
            if (queue == null || EXCLUDE_PATHS.contains(url) || url.contains(".")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                queue.doHandler(chain);
            }
        }
        catch (SsoException e) {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                RequestTool.getResponse().getWriter().write(JsonRender.failResult(e).toJSONString());
            } else {
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                RequestTool.getResponse().getWriter().write(e.getMessage());
            }
        }
        finally {
            RequestTool.removeRequestInThreadLocal();
        }
    }

    public void destroy() {
        queue = null;
    }

    public static void setSsoFilterHanderQueue(SsoFilterHandlerQueue queue) {
        SsoFilter.queue = queue;
    }

    public static void setExcludePaths(Set<String> excludePaths) {
        EXCLUDE_PATHS.addAll(excludePaths);
    }

    public static void setSsoContext(SsoContext context) {
        SsoFilterHandlerQueue queue = context.getBean(SsoFilterHandlerQueue.class);
        SsoFilter.setSsoFilterHanderQueue(queue);
        Set<Object> controllerSet = context.getBeansWithAnnotation(Controller.class);
        Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
        HashSet excludePaths = Sets.newHashSet();
        for (Object controller : controllerSet) {
            Method[] methods;
            Class<?> ultimateTargetClass = AopUtils.isAopProxy((Object)controller) ? AopProxyUtils.ultimateTargetClass((Object)controller) : controller.getClass();
            for (Method method : methods = ultimateTargetClass.getMethods()) {
                CanAccess canAccess = method.getAnnotation(CanAccess.class);
                if (Objects.equal(null, (Object)canAccess)) continue;
                excludePaths.addAll(splitter.splitToList((CharSequence)canAccess.value()));
            }
        }
        SsoFilter.setExcludePaths(excludePaths);
    }

    public static int getHandlerNum() {
        return queue.size();
    }

    public static int getBaiNum() {
        return EXCLUDE_PATHS.size();
    }
}

