/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.logger.service;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoBeanAware;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.logger.SsoLogger;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.logger.runnable.SsoLoggerRunnable;
import cn.com.duiba.sso.api.web.tool.RequestParams;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.util.concurrent.ExecutorService;

@SsoComponent
public class SsoLoggerService
implements SsoBeanAware {
    private ExecutorService executorService;
    private RemoteManagerLogService remoteManagerLogService;
    private SystemEnum system;
    private ThreadLocal<SsoLoggerTheadContext> threadContext = new ThreadLocal();

    public void log(JSONObject json) {
        this.threadContext.get().addParams(json);
    }

    public void setThreadContext(SsoLoggerTheadContext context) {
        if (this.threadContext.get() == null) {
            this.threadContext.set(context);
        }
    }

    public void flushThreadContext() {
        SsoLoggerTheadContext context = this.threadContext.get();
        if (Objects.equal(null, (Object)context)) {
            return;
        }
        RequestParams params = RequestTool.getRequestParams();
        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setSystem(this.system);
        runnable.setRequestParams(params);
        runnable.setContext(context);
        runnable.setRemoteManagerLogService(this.remoteManagerLogService);
        this.executorService.submit(runnable);
        this.threadContext.remove();
    }

    @Override
    public void setContext(SsoContext context) {
        this.executorService = context.getBean(ExecutorService.class);
        this.remoteManagerLogService = context.getBean(RemoteManagerLogService.class);
        this.system = context.getSsoSystemProperties().getSystem();
        SsoLogger.setSsoLoggerService(this);
    }
}

