/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.tool;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParams
implements Serializable,
Cloneable {
    private Logger logger = LoggerFactory.getLogger(RequestParams.class);
    public static final String LOCALHOST_IP = "127.0.0.1";
    private Map<String, String> cookies = Collections.emptyMap();
    private String url;
    private String ip;
    private AdminDto admin;

    public String getUrl() {
        return this.url;
    }

    protected void addCookie(String name, String value) {
        this.cookies.put(name, value);
    }

    public String getCookie(String name) {
        return this.cookies.get(name);
    }

    public AdminDto getAdmin() {
        return this.admin;
    }

    public void setAdmin(AdminDto admin) {
        this.admin = admin;
    }

    public String getIp() {
        return this.ip;
    }

    public static RequestParams parse(HttpServletRequest request) {
        if (request == null) {
            throw new SsoRunTimeException("RequestParams\u89e3\u6790\u65f6\u7684request\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RequestParams rp = new RequestParams();
        Map<String, String> cookieMap = RequestParams.parseCookies(request);
        rp.url = RequestParams.parseUrl(request);
        rp.cookies = cookieMap;
        rp.ip = RequestParams.parseIp(request);
        return rp;
    }

    private static String parseUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            sb.append("?").append(queryString);
        }
        return sb.toString();
    }

    private static Map<String, String> parseCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        HashMap cookieMap = Maps.newHashMap();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }

    private static String parseIp(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = LOCALHOST_IP;
        }
        return ip;
    }

    protected RequestParams clone() {
        try {
            return (RequestParams)super.clone();
        }
        catch (Exception e) {
            this.logger.error("RequestParams\u590d\u5236\u5931\u8d25", (Throwable)e);
            throw new SsoRunTimeException(e);
        }
    }
}

