/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.tool;

import cn.com.duiba.service.exception.BusinessException;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidatorTool {
    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public static <T> List<String> getValidatorErrorList(T pojo) {
        Validator validator = factory.getValidator();
        Set errorSet = validator.validate(pojo, new Class[0]);
        if (errorSet.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList list = Lists.newLinkedList();
        Iterator it = errorSet.iterator();
        while (it.hasNext()) {
            list.add(((ConstraintViolation)it.next()).getMessage());
        }
        return list;
    }

    public static <T> void valid(T pojo) throws BusinessException {
        List<String> errorList = ValidatorTool.getValidatorErrorList(pojo);
        if (errorList.isEmpty()) {
            return;
        }
        throw new BusinessException(errorList.get(0));
    }
}

