package cn.com.duiba.sso.api;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.web.annotation.CanAccess;
import cn.com.duiba.sso.api.web.filter.SsoFilter;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;

import javax.annotation.PostConstruct;

/**
 * Created by liuyao on 2017/5/12.
 * Sso启动入口
 */
public class SsoSystemAware implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    private SystemEnum system;

    private String defaultRedirectUrl = "/";

    private String loginUrl;

    /**
     * 启动方法
     */
    @PostConstruct
    public void init(){
        SsoSystemProperties properties = new SsoSystemProperties();
        BeanUtils.copyProperties(this,properties);

        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        queue.init(applicationContext,properties);

        SsoFilter.setSsoFilterHanderQueue(queue);//注入拦截队列
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext){
        this.applicationContext = applicationContext;
        Map<String, Object> controllerMap = applicationContext.getBeansWithAnnotation(Controller.class);
        Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();
        Set<String> excludePaths = Sets.newHashSet();

        for(String name:controllerMap.keySet()){
            Object controller = controllerMap.get(name);
            Method[] methods = controller.getClass().getMethods();
            for(Method method:methods){
                CanAccess canAccess = method.getAnnotation(CanAccess.class);
                if(!Objects.equal(null,canAccess)){
                    excludePaths.addAll(splitter.splitToList(canAccess.value()));
                }
            }
        }
        SsoFilter.setExcludePaths(excludePaths);//注入白名单
    }

    public SystemEnum getSystem() {
        return system;
    }

    public void setSystem(SystemEnum system) {
        this.system = system;
    }

    public String getLoginUrl() {
        return loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getDefaultRedirectUrl() {
        return defaultRedirectUrl;
    }

    public void setDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
    }
}
