package cn.com.duiba.sso.api.domain.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/5/11.
 */
public enum SystemEnum {

    SSO(0L,"SSO",""),
    DUI_BA(1L,"兑吧",""),
    QI_HUO(2L,"奇货","");

    private static Map<Long,SystemEnum> companyEnumMap = Maps.newHashMap();
    static {
        for(SystemEnum company: SystemEnum.values()){
            companyEnumMap.put(company.getId(),company);
        }
    }

    private SystemEnum(Long id, String name, String logo){
        this.id = id;
        this.name = name;
        this.logo = logo;
    }

    private Long id;
    private String name;
    private String logo;

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getLogo() {
        return logo;
    }

    public static SystemEnum getCompanyEnumById(Long id){
        return companyEnumMap.get(id);
    }
}
