package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.params.CreateAdminParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2017/5/12.
 */
public interface RemoteAdminService {
    /**
     * 获取管理员
     * @param id
     * @return
     */
    DubboResult<AdminDto> findAdmin(Long id);

    /**
     * 查询所有的管理员
     * @return
     */
    DubboResult<List<AdminDto>> findAllAdmin();

    /**
     * 更新TokenSecret
     * @param adminId
     * @param tokenSecret
     * @return
     */
    DubboResult<Boolean> resetTokenSecret(Long adminId,String tokenSecret);

    /**
     * 创建管理员
     * @param params
     * @return
     */
    DubboResult<Long> createAdmin(CreateAdminParams params);

}
