package cn.com.duiba.sso.api.web.filterhandler;

import javax.servlet.FilterChain;

import com.google.common.base.Objects;

import cn.com.duiba.sso.api.exception.SsoException;

/**
 * Created by liuyao on 2017/5/11.
 * SSO 拦截行为拓展接口
 * 职责链设计模式
 */
public abstract class SsoFilterHandler {

    public static final Integer DEFAULT_ORDER = 0;

    /**
     * 获取排列权重 小于0 则在chain.doFilter 之前执行,反之则之后执行
     * @return
     */
    protected abstract Integer getOrder();

    protected abstract void init(SsoFilterHandlerContext context);

    /**
     * getOrder()大于0是不要调用chain.ofFilter
     *
     * @param chain
     * @throws SsoException
     */
    public abstract Boolean doHandler(FilterChain chain) throws SsoException;

}
