package cn.com.duiba.sso.api.web.filterhandler;

import java.util.List;
import java.util.Map;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;
import cn.com.duiba.wolf.utils.ClassUtils;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import org.springframework.context.ApplicationContext;

import com.google.common.collect.Maps;

/**
 * Created by liuyao on 2017/5/11.
 * 管理SSO对外所有的接口
 */
public class SsoFilterHandlerContext {

    private Map<Class<?>,Object> remoteServiceMap = Maps.newHashMap();

    private ApplicationContext applicationContext;

    private SsoSystemProperties properties;

    protected SsoFilterHandlerContext(ApplicationContext applicationContext,SsoSystemProperties properties){
        this.properties = properties;
        this.applicationContext = applicationContext;
        //反射SSO所有的远程接口
        try {

            List<Class<?>> classes = ClassUtils.getClassList("cn.com.duiba.sso.api.remoteservice",true,null);
            for(Class clazz : classes){
                Object bean = applicationContext.getBean(clazz);
                if(!Objects.equal(null,bean)){
                    remoteServiceMap.put(clazz,bean);
                }
            }
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }

    protected ApplicationContext getApplicationContext(){
        return applicationContext;
    }

    public <T> T getRemoteService(Class<T> clazz){
        if(!remoteServiceMap.containsKey(clazz)){
            return null;
        }
        return (T)remoteServiceMap.get(clazz);
    }

    public SsoSystemProperties getSsoSystemProperties() {
        return properties;
    }
}
