package cn.com.duiba.sso.api.web.filterhandler;

import java.util.List;
import java.util.Set;

import javax.servlet.FilterChain;

import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;
import cn.com.duiba.wolf.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;

/**
 * Created by liuyao on 2017/5/11.
 */
public class SsoFilterHandlerQueue {

    private Logger logger = LoggerFactory.getLogger(SsoFilterHandlerQueue.class);

    private List<SsoFilterHandler> queueHandlerList;

    private Integer length = 0;

    public void init(ApplicationContext applicationContext,SsoSystemProperties properties){
        try{
            SsoFilterHandlerContext manager = new SsoFilterHandlerContext(applicationContext,properties);

            List<Class<?>> classes =ClassUtils.getClassList("cn.com.duiba.sso.api.web.filterhandler.handler",true,null);

            List<SsoFilterHandler> handlerList = Lists.newArrayList();
            Set<Integer> orderSet = Sets.newHashSet();

            for(Class clazz : classes){
                if(SsoFilterHandler.class.isAssignableFrom(clazz)){
                    SsoFilterHandler ssoFilterHandler = (SsoFilterHandler) clazz.newInstance();
                    ssoFilterHandler.init(manager);
                    orderSet.add(ssoFilterHandler.getOrder());
                    handlerList.add(ssoFilterHandler);
                }
            }
            if(orderSet.size()!=handlerList.size()){
                throw new SsoRunTimeException("Sso拦截序列存在");
            }
            //排序
            Ordering ordering = Ordering.natural().onResultOf(new Function<SsoFilterHandler,Integer>() {
                @Override
                public Integer apply(SsoFilterHandler input) {
                    return input.getOrder();
                }
            });
            queueHandlerList = ordering.sortedCopy(handlerList);
            length = queueHandlerList.size();

            logger.error("检测到拦截队列数:"+length);
        }catch (Exception e){
            new SsoRunTimeException(e);
        }
    }

    public void doHandler(FilterChain chain) throws SsoException {
        for(SsoFilterHandler handler:queueHandlerList){
            boolean doNext = handler.doHandler(chain);//至少存在一个默认的handler
            if(!doNext){
                break;
            }
        }
    }

    public Integer size(){
        return length;
    }
}
